###################################################################################################
###################################       loadin  library     #####################################
###################################################################################################
cccol <- c("#CE0013","#16557A","#C7A609","#87C232","#64C0AB","#A14C94","#15A08C","#8B7E75","#1E7CAF","#EA425F","#46489A","#E50033","#0F231F","#1187CD")
library(gplots)
library(amap)

SpecificGene <- function(x,given_time,mean_cutoff){
    # find whether this gene is specific expressed in the given time point
    # if (mean(x) >= mean_cutoff & x[given_time]==max(x)){
    if (mean(x) >= mean_cutoff & given_time %in% names(x)[order(x,decreasing=T)[1:1]]){
        return (x[given_time]/mean(x))
    }
    else{
        return (NA)
    }
}

repeatsToFamily <- function(X,repeats_class_family){
	out <- c()
	for (each in X){
		out <- c(out,as.matrix(repeats_class_family[which(repeats_class_family[1]==each),3]))
	}
	return (out)
}
###################################################################################################
###################################         read data         #####################################
###################################################################################################
Oocyte <- 1:3; Zygote <- 4:6; cell2 <- 7:12; cell4 <- 13:24; cell8 <- 25:43; Morula <- 44:59;MTE <- c(63,66,68,69,71,76:79);PTE <- c(60:62,64,65,67,70,73,81); PE <- c(83:89);EPI <- c(72,74:75,80,82);hESC0 <- 90:95; hESC10 <- 96:121
development_repeats_fpkm <- read.table("../data/develop_repeats_fpkm.txt",row.names=1,header=T)
developmentRepeatsAverageFpkm <- cbind(apply(development_repeats_fpkm[Oocyte],1,mean),apply(development_repeats_fpkm[Zygote],1,mean),apply(development_repeats_fpkm[cell2],1,mean),
	apply(development_repeats_fpkm[cell4],1,mean),apply(development_repeats_fpkm[cell8],1,mean),apply(development_repeats_fpkm[Morula],1,mean),
	apply(development_repeats_fpkm[MTE],1,mean),apply(development_repeats_fpkm[PTE],1,mean),apply(development_repeats_fpkm[PE],1,mean),apply(development_repeats_fpkm[EPI],1,mean),
	apply(development_repeats_fpkm[hESC0],1,mean),apply(development_repeats_fpkm[hESC10],1,mean))
colnames(developmentRepeatsAverageFpkm) <- c("Oocyte","Zygote","2cell","4cell","8cell","Morula","MTE","PTE","PE","EPI","hESC0","hESC10")
# develop_path <- c("Oocyte","Zygote","2cell","4cell","8cell","Morula","MTE","PTE","PE","EPI","hESC0","hESC10")
develop_path <- c("Oocyte","Zygote","2cell","4cell","8cell","Morula","MTE","PTE","PE","EPI")
developmentRepeatsAverageFpkm <- developmentRepeatsAverageFpkm[,develop_path]
AmplifyDevelopmentRepeatsAverageFpkm <- developmentRepeatsAverageFpkm * 1e3

he0 <- 1:2; he2 <- 3:4; he6 <- 5:6; hiF <- 7:8; n10 <- 9; n12 <- 10:11; n14 <- c(12:13,25); n20 <- c(14:15,26); n24m <- 16:17; n24p <- 18:19; n8 <- c(20:21,24); niPS <- 22:23
naive_repeats_fpkm <- read.table("../data/naive_repeats_fpkm.txt",row.names=1,header=T)
naiveRepeatsAverageFpkm <- cbind(apply(naive_repeats_fpkm[hiF],1,mean),apply(naive_repeats_fpkm[he0],1,mean),apply(naive_repeats_fpkm[he2],1,mean),
	apply(naive_repeats_fpkm[he6],1,mean),apply(naive_repeats_fpkm[n8],1,mean),apply(naive_repeats_fpkm[n12],1,mean),
	apply(naive_repeats_fpkm[n14],1,mean),apply(naive_repeats_fpkm[n20],1,mean),apply(naive_repeats_fpkm[n24m],1,mean),apply(naive_repeats_fpkm[n24p],1,mean),
	apply(naive_repeats_fpkm[niPS],1,mean))
naiveRepeatsSD <- cbind(apply(naive_repeats_fpkm[hiF],1,sd),apply(naive_repeats_fpkm[he0],1,sd),apply(naive_repeats_fpkm[he2],1,sd),
	apply(naive_repeats_fpkm[he6],1,sd),apply(naive_repeats_fpkm[n8],1,sd),apply(naive_repeats_fpkm[n12],1,sd),
	apply(naive_repeats_fpkm[n14],1,sd),apply(naive_repeats_fpkm[n20],1,sd),apply(naive_repeats_fpkm[n24m],1,sd),apply(naive_repeats_fpkm[n24p],1,sd),
	apply(naive_repeats_fpkm[niPS],1,sd))
colnames(naiveRepeatsAverageFpkm) <- c("hiF","he0","he2","he6","n8","n12","n14","n20","n24m","n24p","niPS")
colnames(naiveRepeatsSD) <- c("hiF","he0","he2","he6","n8","n12","n14","n20","n24m","n24p","niPS")
AmplifyNaiveRepeatsAverageFpkm <- naiveRepeatsAverageFpkm * 1e3
AmplifyNaiveRepeatsSD <- naiveRepeatsSD * 1e3

p2 <- 1:2; p5 <- 3:4; p8 <- 5:6; p10 <- 7:8; p14 <- 9:10; p20 <- 11:12; p24m <- 13:16; p24p <- 17:18; hiFT <- 19:22; piPS <- 23:26
primed_repeats_fpkm <- read.table("../data/primed_repeats_fpkm.txt",row.names=1,header=T)
primedRepeatsAverageFpkm <- cbind(apply(primed_repeats_fpkm[hiFT],1,mean),apply(primed_repeats_fpkm[p2],1,mean),apply(primed_repeats_fpkm[p5],1,mean),
	apply(primed_repeats_fpkm[p8],1,mean),apply(primed_repeats_fpkm[p10],1,mean),apply(primed_repeats_fpkm[p14],1,mean),apply(primed_repeats_fpkm[p20],1,mean),
	apply(primed_repeats_fpkm[p24m],1,mean),apply(primed_repeats_fpkm[p24p],1,mean),apply(primed_repeats_fpkm[piPS],1,mean))
primedRepeatsSD <- cbind(apply(primed_repeats_fpkm[hiFT],1,sd),apply(primed_repeats_fpkm[p2],1,sd),apply(primed_repeats_fpkm[p5],1,sd),
	apply(primed_repeats_fpkm[p8],1,sd),apply(primed_repeats_fpkm[p10],1,sd),apply(primed_repeats_fpkm[p14],1,sd),apply(primed_repeats_fpkm[p20],1,sd),
	apply(primed_repeats_fpkm[p24m],1,sd),apply(primed_repeats_fpkm[p24p],1,sd),apply(primed_repeats_fpkm[piPS],1,sd))
colnames(primedRepeatsAverageFpkm) <- c("hiFT","p2","p5","p8","p10","p14","p20","p24m","p24p","piPS")
colnames(primedRepeatsSD) <- c("hiFT","p2","p5","p8","p10","p14","p20","p24m","p24p","piPS")
AmplifyPrimedRepeatsAverageFpkm <- primedRepeatsAverageFpkm * 1e3
AmplifyPrimedRepeatsSD <- primedRepeatsSD * 1e3

repeats_class_family <- read.table("../data/hg19.repeats.class.family")

###################################################################################################
##############################         specific gene dection        ###############################
###################################################################################################
develop_eight_cell <- apply(AmplifyDevelopmentRepeatsAverageFpkm[,c("Oocyte","Zygote","2cell","4cell","8cell","Morula","MTE","PTE","PE","EPI")],1,SpecificGene,"8cell",0.1)
develop_8cell_gene <- names(sort(develop_eight_cell,decreasing=T)[1:100])

develop_8cell_gene_family <- repeatsToFamily(develop_8cell_gene,repeats_class_family)

naive_n20 <- apply(AmplifyNaiveRepeatsAverageFpkm,1,SpecificGene,"n20",0.1)
naive_n24m <- apply(AmplifyNaiveRepeatsAverageFpkm,1,SpecificGene,"n24m",0.1)
naive_n24p <- apply(AmplifyNaiveRepeatsAverageFpkm,1,SpecificGene,"n24p",0.1)
naive_niPS <- apply(AmplifyNaiveRepeatsAverageFpkm,1,SpecificGene,"niPS",0.1)
naive_n20_gene <- na.omit(names(sort(naive_n20,decreasing=T)[1:50]))
naive_n24m_gene <- na.omit(names(sort(naive_n24m,decreasing=T)[1:50]))
naive_n24p_gene <- na.omit(names(sort(naive_n24p,decreasing=T)[1:50]))
naive_niPS_gene <- na.omit(names(sort(naive_niPS,decreasing=T)[1:50]))
selected_time_genes <- list(naive_n20_gene,naive_n24m_gene,naive_n24p_gene,naive_niPS_gene)
###################################################################################################
###################################           plot            #####################################
###################################################################################################
# pdf(file = paste("Fig3IJ_1.pdf",sep=""), width = 9, height = 2.3)
# layout(matrix(c(rep(1,4),rep(2,4),rep(3,4)),nrow=4,ncol=3))
# par(oma=c(0.5,0.5,0.5,0.5),mar=c(6,7,4,3))
# naivePlotMatrix <- c()
# primedPlotMatrix <- c()
# developmentPlotMatrix <- c()
# tmp_repeats = c(naive_n20_gene,naive_n24p_gene,naive_n24m_gene)
# tmp_repeats_family <- repeatsToFamily(tmp_repeats,repeats_class_family)
# tmp_repeats <- tmp_repeats[which(tmp_repeats_family=="ERVK")]
# naivePlotMatrix <- rbind(naivePlotMatrix,AmplifyNaiveRepeatsAverageFpkm[tmp_repeats,])
# primedPlotMatrix <- rbind(primedPlotMatrix,AmplifyPrimedRepeatsAverageFpkm[tmp_repeats,])
# developmentPlotMatrix <- rbind(developmentPlotMatrix,AmplifyDevelopmentRepeatsAverageFpkm[tmp_repeats,develop_path])
# # development n20
# all_exp <- c(as.matrix(developmentPlotMatrix))
# zmax <- quantile(all_exp,0.99)
# zmin <- quantile(all_exp,0.01)
# developmentPlotMatrix[developmentPlotMatrix<zmin] <- zmin
# developmentPlotMatrix[developmentPlotMatrix>zmax] <- zmax
# ColorRamp <- colorRampPalette(c("lightblue","red"), bias=1)(10000)   #color list
# ColorLevels <- seq(to=zmax,from=zmin, length=10000)   #number sequence
# image(1:ncol(developmentPlotMatrix), 1:nrow(developmentPlotMatrix), t(developmentPlotMatrix), xaxt="n", yaxt="n", col=ColorRamp, xlab="", ylab="")
# axis(side=1,1:ncol(developmentPlotMatrix),labels=colnames(developmentPlotMatrix),cex.axis=1.2,las=2);box()
# axis(side=2,1:nrow(developmentPlotMatrix),labels=rownames(developmentPlotMatrix),cex.axis=1.2,las=2);box()
# # naive n20
# all_exp <- c(as.matrix(naivePlotMatrix))
# zmax <- quantile(all_exp,0.99)
# zmin <- quantile(all_exp,0.01)
# naivePlotMatrix[naivePlotMatrix<zmin] <- zmin
# naivePlotMatrix[naivePlotMatrix>zmax] <- zmax
# ColorRamp <- colorRampPalette(c("lightblue","red"), bias=1)(10000)   #color list
# ColorLevels <- seq(to=zmax,from=zmin, length=10000)   #number sequence
# image(1:ncol(naivePlotMatrix), 1:nrow(naivePlotMatrix), t(naivePlotMatrix), xaxt="n",yaxt="n", col=ColorRamp, xlab="", ylab="")
# axis(side=1,1:ncol(naivePlotMatrix),labels=c("hiF-T","0d","2d","6d","8d","12d","14d","20d","24d+dox","24d-dox","niPSC-T"),cex.axis=1.2,las=2);box()
# axis(side=2,1:nrow(naivePlotMatrix),labels=rownames(naivePlotMatrix),cex.axis=1.2,las=2);box()
# # primed n20
# all_exp <- c(as.matrix(primedPlotMatrix))
# zmax <- quantile(all_exp,0.99)
# zmin <- quantile(all_exp,0.01)
# primedPlotMatrix[primedPlotMatrix<zmin] <- zmin
# primedPlotMatrix[primedPlotMatrix>zmax] <- zmax
# ColorRamp <- colorRampPalette(c("lightblue","red"), bias=1)(10000)   #color list
# ColorLevels <- seq(to=zmax,from=zmin, length=10000)   #number sequence
# image(1:ncol(primedPlotMatrix), 1:nrow(primedPlotMatrix), t(primedPlotMatrix), xaxt="n",yaxt="n", col=ColorRamp, xlab="", ylab="")
# axis(side=1,1:ncol(primedPlotMatrix),labels=c("hiF-T","2d","5d","8d","10d","14d","20d","24d+dox","24d-dox","piPSC-T"),cex.axis=1.2,las=2);box()
# axis(side=2,1:nrow(primedPlotMatrix),labels=rownames(primedPlotMatrix),cex.axis=1.2,las=2);box()
# dev.off()

# pdf(file = paste("Fig3IJ_2.pdf",sep=""), width = 9, height = 1.5)
# layout(matrix(c(rep(1,4),rep(2,4),rep(3,4)),nrow=4,ncol=3))
# par(oma=c(0.5,0.5,0.5,0.5),mar=c(5,7,5,3))
# naivePlotMatrix <- c()
# primedPlotMatrix <- c()
# developmentPlotMatrix <- c()
# tmp_repeats = c(naive_n20_gene,naive_n24p_gene,naive_n24m_gene)
# tmp_repeats_family <- repeatsToFamily(tmp_repeats,repeats_class_family)
# tmp_repeats <- tmp_repeats[which(tmp_repeats_family=="ERVK")]
# naivePlotMatrix <- rbind(naivePlotMatrix,AmplifyNaiveRepeatsAverageFpkm[tmp_repeats,])
# primedPlotMatrix <- rbind(primedPlotMatrix,AmplifyPrimedRepeatsAverageFpkm[tmp_repeats,])
# developmentPlotMatrix <- rbind(developmentPlotMatrix,AmplifyDevelopmentRepeatsAverageFpkm[tmp_repeats,])
# # development n20 legend
# all_exp <- c(as.matrix(developmentPlotMatrix))
# zmax <- quantile(all_exp,0.99)
# zmin <- quantile(all_exp,0.01)
# ColorLevels <- seq(to=zmax,from=zmin, length=10000)
# image(ColorLevels,1,matrix(data=ColorLevels, nrow=length(ColorLevels),ncol=1),col=ColorRamp, xlab="",ylab="",cex.axis=1,xaxt="n",yaxt="n",useRaster=T)
# axis(side=1,c(zmin,(zmax-zmin)/2,zmax),labels=c(round(zmin,1),round((zmax-zmin)/2,1),round(zmax,1)))
# # naive n20 legend
# all_exp <- c(as.matrix(naivePlotMatrix))
# zmax <- quantile(all_exp,0.99)
# zmin <- quantile(all_exp,0.01)
# ColorLevels <- seq(to=zmax,from=zmin, length=10000)
# image(ColorLevels,1,matrix(data=ColorLevels, nrow=length(ColorLevels),ncol=1),col=ColorRamp, xlab="",ylab="",cex.axis=1,xaxt="n",yaxt="n",useRaster=T)
# axis(side=1,c(zmin,(zmax-zmin)/2,zmax),labels=c(round(zmin,1),round((zmax-zmin)/2,1),round(zmax,1)))
# # primed n20 legend
# all_exp <- c(as.matrix(primedPlotMatrix))
# zmax <- quantile(all_exp,0.99)
# zmin <- quantile(all_exp,0.01)
# ColorLevels <- seq(to=zmax,from=zmin, length=10000)
# image(ColorLevels,1,matrix(data=ColorLevels, nrow=length(ColorLevels),ncol=1),col=ColorRamp, xlab="",ylab="",cex.axis=1,xaxt="n",yaxt="n",useRaster=T)
# axis(side=1,c(zmin,(zmax-zmin)/2,zmax),labels=c(round(zmin,1),round((zmax-zmin)/2,1),round(zmax,1)))
# dev.off()

pdf(file = paste("Fig3IJ_1.pdf",sep=""), width = 9, height = 2.3)
layout(matrix(c(rep(1,4),rep(2,4),rep(3,4)),nrow=4,ncol=3))
par(oma=c(0.5,0.5,0.5,0.5),mar=c(6,7,4,3))
naivePlotMatrix <- c()
primedPlotMatrix <- c()
developmentPlotMatrix <- c()
tmp_repeats <- rev(c("LTR14","MER9a3","LTR5B","MER11A","HERVK9-int"))
naivePlotMatrix <- rbind(naivePlotMatrix,AmplifyNaiveRepeatsAverageFpkm[tmp_repeats,])
primedPlotMatrix <- rbind(primedPlotMatrix,AmplifyPrimedRepeatsAverageFpkm[tmp_repeats,])
developmentPlotMatrix <- rbind(developmentPlotMatrix,AmplifyDevelopmentRepeatsAverageFpkm[tmp_repeats,develop_path])
# development n20
all_exp <- c(as.matrix(developmentPlotMatrix))
zmax <- quantile(all_exp,0.99)
zmin <- quantile(all_exp,0.01)
developmentPlotMatrix[developmentPlotMatrix<zmin] <- zmin
developmentPlotMatrix[developmentPlotMatrix>zmax] <- zmax
ColorRamp <- colorRampPalette(c("lightblue","red"), bias=1)(10000)   #color list
ColorLevels <- seq(to=zmax,from=zmin, length=10000)   #number sequence
image(1:ncol(developmentPlotMatrix), 1:nrow(developmentPlotMatrix), t(developmentPlotMatrix), xaxt="n", yaxt="n", col=ColorRamp, xlab="", ylab="")
axis(side=1,1:ncol(developmentPlotMatrix),labels=colnames(developmentPlotMatrix),cex.axis=1.2,las=2);box()
axis(side=2,1:nrow(developmentPlotMatrix),labels=rownames(developmentPlotMatrix),cex.axis=1.2,las=2);box()
# naive n20
all_exp <- c(as.matrix(naivePlotMatrix))
zmax <- quantile(all_exp,0.99)
zmin <- quantile(all_exp,0.01)
naivePlotMatrix[naivePlotMatrix<zmin] <- zmin
naivePlotMatrix[naivePlotMatrix>zmax] <- zmax
ColorRamp <- colorRampPalette(c("lightblue","red"), bias=1)(10000)   #color list
ColorLevels <- seq(to=zmax,from=zmin, length=10000)   #number sequence
image(1:ncol(naivePlotMatrix), 1:nrow(naivePlotMatrix), t(naivePlotMatrix), xaxt="n",yaxt="n", col=ColorRamp, xlab="", ylab="")
axis(side=1,1:ncol(naivePlotMatrix),labels=c("hiF-T","0d","2d","6d","8d","12d","14d","20d","24d+dox","24d-dox","niPSC-T"),cex.axis=1.2,las=2);box()
axis(side=2,1:nrow(naivePlotMatrix),labels=rownames(naivePlotMatrix),cex.axis=1.2,las=2);box()
# primed n20
all_exp <- c(as.matrix(primedPlotMatrix))
zmax <- quantile(all_exp,0.99)
zmin <- quantile(all_exp,0.01)
primedPlotMatrix[primedPlotMatrix<zmin] <- zmin
primedPlotMatrix[primedPlotMatrix>zmax] <- zmax
ColorRamp <- colorRampPalette(c("lightblue","red"), bias=1)(10000)   #color list
ColorLevels <- seq(to=zmax,from=zmin, length=10000)   #number sequence
image(1:ncol(primedPlotMatrix), 1:nrow(primedPlotMatrix), t(primedPlotMatrix), xaxt="n",yaxt="n", col=ColorRamp, xlab="", ylab="")
axis(side=1,1:ncol(primedPlotMatrix),labels=c("hiF-T","2d","5d","8d","10d","14d","20d","24d+dox","24d-dox","piPSC-T"),cex.axis=1.2,las=2);box()
axis(side=2,1:nrow(primedPlotMatrix),labels=rownames(primedPlotMatrix),cex.axis=1.2,las=2);box()
dev.off()

pdf(file = paste("Fig3IJ_2.pdf",sep=""), width = 9, height = 1.5)
layout(matrix(c(rep(1,4),rep(2,4),rep(3,4)),nrow=4,ncol=3))
par(oma=c(0.5,0.5,0.5,0.5),mar=c(5,7,5,3))
naivePlotMatrix <- c()
primedPlotMatrix <- c()
developmentPlotMatrix <- c()
tmp_repeats <- rev(c("LTR14","MER9a3","LTR5B","MER11A","HERVK9-int"))
naivePlotMatrix <- rbind(naivePlotMatrix,AmplifyNaiveRepeatsAverageFpkm[tmp_repeats,])
primedPlotMatrix <- rbind(primedPlotMatrix,AmplifyPrimedRepeatsAverageFpkm[tmp_repeats,])
developmentPlotMatrix <- rbind(developmentPlotMatrix,AmplifyDevelopmentRepeatsAverageFpkm[tmp_repeats,])
# development n20 legend
all_exp <- c(as.matrix(developmentPlotMatrix))
zmax <- quantile(all_exp,0.99)
zmin <- quantile(all_exp,0.01)
ColorLevels <- seq(to=zmax,from=zmin, length=10000)
image(ColorLevels,1,matrix(data=ColorLevels, nrow=length(ColorLevels),ncol=1),col=ColorRamp, xlab="",ylab="",cex.axis=1,xaxt="n",yaxt="n",useRaster=T)
axis(side=1,c(zmin,(zmax-zmin)/2,zmax),labels=c(round(zmin,1),round((zmax-zmin)/2,1),round(zmax,1)))
# naive n20 legend
all_exp <- c(as.matrix(naivePlotMatrix))
zmax <- quantile(all_exp,0.99)
zmin <- quantile(all_exp,0.01)
ColorLevels <- seq(to=zmax,from=zmin, length=10000)
image(ColorLevels,1,matrix(data=ColorLevels, nrow=length(ColorLevels),ncol=1),col=ColorRamp, xlab="",ylab="",cex.axis=1,xaxt="n",yaxt="n",useRaster=T)
axis(side=1,c(zmin,(zmax-zmin)/2,zmax),labels=c(round(zmin,1),round((zmax-zmin)/2,1),round(zmax,1)))
# primed n20 legend
all_exp <- c(as.matrix(primedPlotMatrix))
zmax <- quantile(all_exp,0.99)
zmin <- quantile(all_exp,0.01)
ColorLevels <- seq(to=zmax,from=zmin, length=10000)
image(ColorLevels,1,matrix(data=ColorLevels, nrow=length(ColorLevels),ncol=1),col=ColorRamp, xlab="",ylab="",cex.axis=1,xaxt="n",yaxt="n",useRaster=T)
axis(side=1,c(zmin,(zmax-zmin)/2,zmax),labels=c(round(zmin,1),round((zmax-zmin)/2,1),round(zmax,1)))
dev.off()


pdf(file = paste("SFig3B_1.pdf",sep=""), width = 9, height = 2.3)
layout(matrix(c(rep(1,4),rep(2,4),rep(3,4)),nrow=4,ncol=3))
par(oma=c(0.5,0.5,0.5,0.5),mar=c(6,7,4,3))
naivePlotMatrix <- c()
primedPlotMatrix <- c()
developmentPlotMatrix <- c()
tmp_repeats = naive_niPS_gene
tmp_repeats_family <- repeatsToFamily(tmp_repeats,repeats_class_family)
tmp_repeats <- tmp_repeats[which(tmp_repeats_family=="Other")]
naivePlotMatrix <- rbind(naivePlotMatrix,AmplifyNaiveRepeatsAverageFpkm[tmp_repeats,])
primedPlotMatrix <- rbind(primedPlotMatrix,AmplifyPrimedRepeatsAverageFpkm[tmp_repeats,])
developmentPlotMatrix <- rbind(developmentPlotMatrix,AmplifyDevelopmentRepeatsAverageFpkm[tmp_repeats,])
# development niPS
all_exp <- c(as.matrix(developmentPlotMatrix))
zmax <- quantile(all_exp,0.99)
zmin <- quantile(all_exp,0.01)
developmentPlotMatrix[developmentPlotMatrix<zmin] <- zmin
developmentPlotMatrix[developmentPlotMatrix>zmax] <- zmax
ColorRamp <- colorRampPalette(c("lightblue","red"), bias=1)(10000)   #color list
ColorLevels <- seq(to=zmax,from=zmin, length=10000)   #number sequence
image(1:ncol(developmentPlotMatrix), 1:nrow(developmentPlotMatrix), t(developmentPlotMatrix), xaxt="n", yaxt="n", col=ColorRamp, xlab="", ylab="")
axis(side=1,1:ncol(developmentPlotMatrix),labels=colnames(developmentPlotMatrix),cex.axis=1.2,las=2);box()
axis(side=2,1:nrow(developmentPlotMatrix),labels=rownames(developmentPlotMatrix),cex.axis=1.2,las=2);box()
# naive niPS
all_exp <- c(as.matrix(naivePlotMatrix))
zmax <- quantile(all_exp,0.99)
zmin <- quantile(all_exp,0.01)
naivePlotMatrix[naivePlotMatrix<zmin] <- zmin
naivePlotMatrix[naivePlotMatrix>zmax] <- zmax
ColorRamp <- colorRampPalette(c("lightblue","red"), bias=1)(10000)   #color list
ColorLevels <- seq(to=zmax,from=zmin, length=10000)   #number sequence
image(1:ncol(naivePlotMatrix), 1:nrow(naivePlotMatrix), t(naivePlotMatrix), xaxt="n",yaxt="n", col=ColorRamp, xlab="", ylab="")
axis(side=1,1:ncol(naivePlotMatrix),labels=c("hiF-T","0d","2d","6d","8d","12d","14d","20d","24d+dox","24d-dox","niPSC-T"),cex.axis=1.2,las=2);box()
axis(side=2,1:nrow(naivePlotMatrix),labels=rownames(naivePlotMatrix),cex.axis=1.2,las=2);box()
# primed niPS
all_exp <- c(as.matrix(primedPlotMatrix))
zmax <- quantile(all_exp,0.99)
zmin <- quantile(all_exp,0.01)
primedPlotMatrix[primedPlotMatrix<zmin] <- zmin
primedPlotMatrix[primedPlotMatrix>zmax] <- zmax
ColorRamp <- colorRampPalette(c("lightblue","red"), bias=1)(10000)   #color list
ColorLevels <- seq(to=zmax,from=zmin, length=10000)   #number sequence
image(1:ncol(primedPlotMatrix), 1:nrow(primedPlotMatrix), t(primedPlotMatrix), xaxt="n",yaxt="n", col=ColorRamp, xlab="", ylab="")
axis(side=1,1:ncol(primedPlotMatrix),labels=c("hiF-T","2d","5d","8d","10d","14d","20d","24d+dox","24d-dox","piPSC-T"),cex.axis=1.2,las=2);box()
axis(side=2,1:nrow(primedPlotMatrix),labels=rownames(primedPlotMatrix),cex.axis=1.2,las=2);box()
dev.off()

pdf(file = paste("SFig3B_2.pdf",sep=""), width = 9, height = 1.5)
layout(matrix(c(rep(1,4),rep(2,4),rep(3,4)),nrow=4,ncol=3))
par(oma=c(0.5,0.5,0.5,0.5),mar=c(5,7,5,3))
naivePlotMatrix <- c()
primedPlotMatrix <- c()
developmentPlotMatrix <- c()
tmp_repeats = naive_niPS_gene
tmp_repeats_family <- repeatsToFamily(tmp_repeats,repeats_class_family)
tmp_repeats <- tmp_repeats[which(tmp_repeats_family=="Other")]
naivePlotMatrix <- rbind(naivePlotMatrix,AmplifyNaiveRepeatsAverageFpkm[tmp_repeats,])
primedPlotMatrix <- rbind(primedPlotMatrix,AmplifyPrimedRepeatsAverageFpkm[tmp_repeats,])
developmentPlotMatrix <- rbind(developmentPlotMatrix,AmplifyDevelopmentRepeatsAverageFpkm[tmp_repeats,])
# development niPS legend
all_exp <- c(as.matrix(developmentPlotMatrix))
zmax <- quantile(all_exp,0.99)
zmin <- quantile(all_exp,0.01)
ColorLevels <- seq(to=zmax,from=zmin, length=10000)
image(ColorLevels,1,matrix(data=ColorLevels, nrow=length(ColorLevels),ncol=1),col=ColorRamp, xlab="",ylab="",cex.axis=1,xaxt="n",yaxt="n",useRaster=T)
axis(side=1,c(zmin,(zmax-zmin)/2,zmax),labels=c(round(zmin,1),round((zmax-zmin)/2,1),round(zmax,1)))
# naive niPS legend
all_exp <- c(as.matrix(naivePlotMatrix))
zmax <- quantile(all_exp,0.99)
zmin <- quantile(all_exp,0.01)
ColorLevels <- seq(to=zmax,from=zmin, length=10000)
image(ColorLevels,1,matrix(data=ColorLevels, nrow=length(ColorLevels),ncol=1),col=ColorRamp, xlab="",ylab="",cex.axis=1,xaxt="n",yaxt="n",useRaster=T)
axis(side=1,c(zmin,(zmax-zmin)/2,zmax),labels=c(round(zmin,1),round((zmax-zmin)/2,1),round(zmax,1)))
# primed n20 legend
all_exp <- c(as.matrix(primedPlotMatrix))
zmax <- quantile(all_exp,0.99)
zmin <- quantile(all_exp,0.01)
ColorLevels <- seq(to=zmax,from=zmin, length=10000)
image(ColorLevels,1,matrix(data=ColorLevels, nrow=length(ColorLevels),ncol=1),col=ColorRamp, xlab="",ylab="",cex.axis=1,xaxt="n",yaxt="n",useRaster=T)
axis(side=1,c(zmin,(zmax-zmin)/2,zmax),labels=c(round(zmin,1),round((zmax-zmin)/2,1),round(zmax,1)))
dev.off()


